/*

  Name: mmu/mmu.h
  Copyright: IDLE Incomplete Draft of a Lisa Emulator
  Author: G.Fetis
  Date: 11/10/06 09:40
  Description: public header of Lisa MMU

  $Log: mmu.h,v $
  Revision 1.6  2006/12/21 20:58:33  gilles_fetis
  change of 68k core

  Revision 1.4  2006/10/28 09:53:40  gilles_fetis
  added mapped io for disk

  Revision 1.3  2006/10/26 19:43:40  gilles_fetis
  initial disk support and line feed correction

  Revision 1.1  2006/10/12 10:05:12  gilles_fetis
  added initial via support

*/

#define IO_READ 0
#define IO_WRITE 1
#define IO_BYTE 0
#define IO_WORD 1

#include "../config.h"

extern uint32 clock68k;

void registerIoFunc(uint32 address,void (*func)(int*,int,int));
void registerIoFuncAdr(uint32 address,void (*func)(uint32, int*,int,int));
uint8* getVideoMemory(void);
int beginVBL(void);
void endVBL(void);
uint16 LisaGetWDebug(uint32 address);
void   MemInit(void);
void mmuReset(void);
void refresh_mmu_box(void);

